Scriptname RF:OverheatScript Extends ActiveMagicEffect

RF:FuelHandlerQuest Property RFQ Auto Mandatory Const

Message Property TheMessage Mandatory Const Auto
Message Property TheMessageFailedToRepair Mandatory Const Auto

WwiseEvent Property TheSoundOnFail Mandatory Const Auto
WwiseEvent Property TheSoundOnOK Mandatory Const Auto

Spell Property TheOverheatSpell Mandatory Const Auto

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    RFQ.DisableFarTravel(true)
    TheSoundOnFail.Play(akCaster)
EndEvent

Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    If RFQ.HandleOverheatEnd()
        RFQ.DisableFarTravel(false)
        RFQ.HelpMessage(TheMessage)
        TheSoundOnOK.Play(akCaster)
    Else
        TheSoundOnFail.Play(akCaster)
        TheOverheatSpell.Cast(akCaster)
        RFQ.HelpMessage(TheMessageFailedToRepair)
        ;NOTE this should recast the spell if we failed to repair the grav drive and the ship to at least half. this requires damaging both of course
    EndIf
EndEvent